<?php
/* --------------------------------------------------------------
   SeoTagsService.php 2025-09-11
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
declare(strict_types=1);

namespace Gambio\Admin\Modules\SeoTags;

use Gambio\Admin\Modules\SeoTags\Decorator\CategoryPageNoIndexKeysDecorator;
use Gambio\Core\Configuration\Services\ConfigurationService as ConfigurationServiceInterface;

class SeoTagsService
{
    const INDEX_META_CONFIG_KEY = 'gm_configuration/GM_TITLE_CHANGE_CATEGORY_META_INDEX';
    
    /**
     * @var ConfigurationServiceInterface $configurationService
     */
    private ConfigurationServiceInterface $configurationService;
    
    
    /**
     * @param ConfigurationServiceInterface $configurationService
     */
    public function __construct(ConfigurationServiceInterface $configurationService)
    {
        $this->configurationService = $configurationService;
    }
    
    
    /**
     * @return array
     */
    public function getSeoTags(): array
    {
        $decorator = new CategoryPageNoIndexKeysDecorator();
        
        return $decorator->getNoIndexKeysPerPageType();
    }
    
    
    /**
     * @return bool
     */
    public function isIndexForCategoryPagesActive(): bool
    {
        $isActive = false;
        if ($this->configurationService->has(self::INDEX_META_CONFIG_KEY)) {
            $isActive = (bool)$this->configurationService->find(self::INDEX_META_CONFIG_KEY)->value();
        }
        
        return $isActive;
    }
    
}